PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144682193"
 Author = "jayas.jayas"
 Desc = "Transformer HL/LV Connection with tertiary winding"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Output("FLT",36,18)
    {
    Type = Integer
    }
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [5]
    }
   Input("FLTLCN",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(37,-18,27,-18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([1584,270],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1584,324],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([1584,378],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([702,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([738,702],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([1314,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1314,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1584,594],3,0,-1)
    {
    Name = "B4T1"
    }
   -Sticky-([1242,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 1242,936,1350,972
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datalabel([1314,990],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1314,1008],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1314,1026],6,0,-1)
    {
    Name = "B3"
    }
   -Sticky-([1566,54],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1566,54,1728,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var([1548,378],0,45529488,60)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1548,324],0,44856080,50)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1548,270],0,44858800,40)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1458,1008],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1584,216],3,0,-1)
    {
    Name = "B1T1"
    }
   0.var([1548,216],0,44862768,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1692,252],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1692,324],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.logic([1728,360],6,0,260)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1728,504],0,0,280)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1692,486],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([846,720],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([702,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([738,738],0,0,-1)
    {
    Name = "Tfd"
    }
   -Wire-([1638,306],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1638,306],6,0,-1)
    {
    Name = "FLTLCN"
    }
   0.export([1404,1134],4,0,370)
    {
    Name = "FLT"
    }
   0.var([1548,540],0,44872344,120)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1548,486],0,44875440,90)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1692,360],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.tbreakn([1656,396],4,0,70)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -ControlPanel-([1242,612],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45737440)
    Slider(45643472)
    Slider(45640696)
    }
   -ControlPanel-([1242,468],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45734440)
    Slider(44875440)
    Slider(44872344)
    }
   0.datalabel([1584,648],3,0,-1)
    {
    Name = "B4T2"
    }
   0.datalabel([1584,486],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1584,540],3,0,-1)
    {
    Name = "B3T2"
    }
   0.var([1548,648],0,45640696,150)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1548,594],0,45643472,130)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.logic([1728,792],6,0,320)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1692,828],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([1638,558],6,0,-1)
    {
    Name = "FLTLCN"
    }
   -Wire-([1638,558],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1692,576],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([1638,738],6,0,-1)
    {
    Name = "FLTLCN"
    }
   -Wire-([1638,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1692,756],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1584,774],3,0,-1)
    {
    Name = "B5T1"
    }
   0.datalabel([1584,828],3,0,-1)
    {
    Name = "B5T2"
    }
   -ControlPanel-([1242,756],0)
    {
    Name = "B5 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45741184)
    Slider(45673424)
    Slider(45676392)
    }
   0.var([1548,774],0,45673424,190)
    {
    Name = "B5T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.3"
    Units = "s"
    Collect = "1"
    }
   0.var([1548,828],0,45676392,200)
    {
    Name = "B5T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.export([1368,1098],4,0,380)
    {
    Name = "BRKR"
    }
   0.datamerge([1332,1062],4,0,360)
    {
    N = "5"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1314,1044],6,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([1314,1062],6,0,-1)
    {
    Name = "B5"
    }
   -Sticky-([558,54],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 558,54,720,144
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the voltage to obtain the matching
VAR flow at each end."
    }
   -Sticky-([54,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,108,180,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([54,306],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(62281576)
    Meter(62076896)
    Slider(62278592)
    Meter(62117432)
    Meter(62169080)
    Meter(62166040)
    Meter(62242072)
    Meter(62239048)
    }
   -Sticky-([1242,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 1242,126,1350,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   0.logic([1728,252],0,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1800,828],6,0,330)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([1836,828],4,0,-1)
    {
    Name = "B5"
    }
   0.logic([1800,216],0,0,340)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([1836,216],6,0,-1)
    {
    Name = "B1"
    }
   0.logic([1800,396],6,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([1836,396],4,0,-1)
    {
    Name = "B2"
    }
   0.logic([1800,468],0,0,350)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([1836,468],2,0,-1)
    {
    Name = "B3"
    }
   0.logic([1728,612],6,0,290)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1836,648],4,0,-1)
    {
    Name = "B4"
    }
   0.var_switch([1728,216],0,45729136,30)
    {
    Name = "42 B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1728,396],0,45731720,80)
    {
    Name = "42 B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1728,468],0,45734440,100)
    {
    Name = "42 B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1692,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.var_switch([1728,648],0,45737440,180)
    {
    Name = "42 B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([1800,648],6,0,310)
    {
    Type = "2"
    Inv = "0"
    }
   0.var_switch([1728,828],0,45741184,220)
    {
    Name = "42 B5"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -ControlPanel-([1242,324],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45731720)
    Slider(44856080)
    Slider(45529488)
    }
   -ControlPanel-([414,432],0)
    {
    Name = "X-former"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,108,126
    Dial(62133464)
    }
   0.import([1422,1008],0,0,230)
    {
    Name = "FLTLCN"
    }
   0.tbreakn([1656,648],4,0,170)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.tbreakn([1656,486],4,0,110)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.tbreakn([1656,216],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.pgb([1530,1008],0,45775848,240)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.tfaultn([810,720],4,0,300)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([54,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,612,162,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([54,180],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(62284944)
    Meter(62073984)
    Slider(62288656)
    Meter(62080704)
    Meter(62024456)
    Meter(62021600)
    Meter(62065496)
    Meter(62244984)
    }
   0.var([666,738],0,61347528,160)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   0.var([666,702],0,61350528,140)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1656,828],4,0,210)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B5T1"
    TO2 = "B5T2"
    }
   -Sticky-([54,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,810,270,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between B1 and HV T1
  2=> FT2:
          Between LV T1and B2
  3=> FT3:
          midpoint on LV Dist Bus
  4=> FT4:
          Between B4 and load
  5=> FT5:
         on Tertiary Winding after B5"
    }
   -Sticky-([306,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 306,810,450,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no fault"
    }
   -ControlPanel-([54,666],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(62123120)
    Dial(62174192)
    Slider(61350528)
    Slider(61347528)
    Slider(62318688)
    }
   -ControlPanel-([1242,180],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45729136)
    Slider(44862768)
    Slider(44858800)
    }
   -Sticky-([918,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 918,450,1170,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn off and  on each recorder individually."
    }
   -ControlPanel-([936,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(62368680)
    Switch(62365960)
    Switch(62363240)
    }
   -ControlPanel-([972,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(62110584)
    Slider(62113736)
    }
   -Sticky-([972,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,126,1080,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -Sticky-([666,774],0)
    {
    Name = ""
    Font = 1
    Bounds = 666,774,936,936
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
A BC Fault is located on the Tertiary Winding 
after Breaker B5, at Fault Location 5.

It is set to occur at 0.2 sec for a duration of 0.1 sec.

Breaker B5 is set to trip at 0.24 sec and
remain open for the duration of the simulation."
    }
   -Divider-([36,576],0)
    {
    Size(1188,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1224,918],0)
    {
    Size(630,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1224,54],0)
    {
    Size(0,1116)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([828,54],0)
    {
    Size(0,522)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 ")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,36],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [36,36]
    Icon = [-1,-1]
    Extents = 0,0,1476,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1476,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(62157064,"V1a",0,,,)
     Curve(62160072,"V1b",1,,,)
     Curve(62162848,"V1c",2,,,)
     }
    Graph([0,268],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(62218968,"I1a",0,,,)
     Curve(62221880,"I1b",1,,,)
     Curve(62224936,"I1c",2,,,)
     }
    Graph([0,536],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(62094536,"I10",0,,,)
     }
    PGraph([0,804],[0,0,1476,249],"PolyGraph")
     {
     Options = 2
     Curve(61968120,"Br1a",0,,,1)
     Curve(61978704,"Br1b",1,,,1)
     Curve(62016512,"Br1c",2,,,1)
     }
    }
   }
  }
 Module("Plots_1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B3 B4")
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Plot-([1116,108],0)
    {
    Title = "Bus 4 and Bus 5 plots "
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,1062,1332
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1062,258],"Current")
     {
     Options = 9
     Units = ""
     Curve(62204784,"I4a",0,,,)
     Curve(62195880,"I4b",1,,,)
     Curve(62198960,"I4c",2,,,)
     }
    Graph([0,258],[0,0,1062,258],"Current")
     {
     Options = 9
     Units = ""
     Curve(62254144,"I5a",0,,,)
     Curve(62268208,"I5b",1,,,)
     Curve(62271120,"I5c",2,,,)
     }
    Graph([0,516],[0,0,1062,257],"Current")
     {
     Options = 9
     Units = ""
     Curve(62201872,"I40",0,,,)
     }
    Graph([0,773],[0,0,1062,257],"y")
     {
     Options = 9
     Units = ""
     Curve(62256920,"I50",0,,,)
     }
    PGraph([0,1030],[0,0,1062,239],"PolyGraph")
     {
     Options = 2
     Curve(61914920,"Br4a",0,,,1)
     Curve(62068432,"Br4b",1,,,1)
     Curve(62071208,"Br4c",2,,,1)
     }
    }
   -Plot-([18,108],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,1062,1062
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1062,255],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(62051256,"V3a",0,,,)
     Curve(62054088,"V3b",1,,,)
     Curve(62106312,"V3c",2,,,)
     }
    Graph([0,255],[0,0,1062,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(62183048,"I3a",0,,,)
     Curve(62191704,"I3b",1,,,)
     Curve(62185880,"I3c",2,,,)
     }
    Graph([0,509],[0,0,1062,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(62188792,"I30",0,,,)
     }
    PGraph([0,763],[0,0,1062,236],"PolyGraph")
     {
     Options = 2
     Curve(62057000,"Br3a",0,,,)
     Curve(62059776,"Br3b",1,,,)
     Curve(62062552,"Br3c",2,,,)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 ")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [36,36]
    Icon = [-1,-1]
    Extents = 0,0,1476,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1476,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(61959728,"V2a",0,,,)
     Curve(61962792,"V2b",1,,,)
     Curve(61989760,"V2c",2,,,)
     }
    Graph([0,268],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(61954040,"I2a",0,,,)
     Curve(61956816,"I2b",1,,,)
     Curve(62029072,"I2c",2,,,)
     }
    Graph([0,536],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(62100488,"I20",0,,,)
     }
    PGraph([0,804],[0,0,1476,249],"PolyGraph")
     {
     Options = 2
     Curve(61972472,"Br2a",0,,,1)
     Curve(61981536,"Br2b",1,,,1)
     Curve(61975032,"Br2c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2268,1152],0,61914920,800)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([360,1224],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([396,1224],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([432,1224],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([738,1224],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([774,1224],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([810,1224],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([2070,828],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([2088,864],0,0,170)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,900],0,0,190)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([252,1224],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([288,1224],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([324,1224],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([630,1224],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([666,1224],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([702,1224],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([558,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,936],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2088,936],0,0,210)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1512,1224],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1692,1188],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1728,1188],2,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([1728,1278],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1692,1440],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1728,1440],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1764,1350],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([864,684],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([1548,1224],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1476,1224],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([774,594],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([576,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([990,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([2106,288],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2106,324],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2106,360],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2106,648],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2106,684],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([2142,648],0,61954040,1060)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([2142,684],0,61956816,1030)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([2142,522],0,61959728,90)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.pgb([2142,558],0,61962792,130)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.datalabel([2232,162],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([2232,198],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([2232,234],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([2268,162],0,61968120,1270)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2232,522],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([2232,558],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([2268,522],0,61972472,1100)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,594],0,61975032,1070)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2232,288],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([2268,198],0,61978704,1250)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,558],0,61981536,1080)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([2088,162],0,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,198],0,0,400)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2070,126],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([2106,162],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([2106,198],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2106,558],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([2142,594],0,61989760,150)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   -Wire-([2232,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,360],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([2232,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,396],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([2232,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,756],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([2106,522],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2232,720],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([2232,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,684],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([2232,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,648],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([2232,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,594],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([2106,720],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([2106,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,162],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,594],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([2088,594],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,558],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2088,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,558],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,594],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2106,234],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([2088,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,198],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,162],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2088,234],0,0,410)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2232,324],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([2268,234],0,62016512,1220)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([2088,522],0,0,80)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2070,486],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([2070,486],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2268,324],0,62021600,1180)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2268,288],0,62024456,1200)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Wire-([2106,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,756],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([2142,720],0,62029072,1010)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   -Wire-([2070,126],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([2106,396],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([2070,828],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([2106,864],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([2106,900],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([2106,936],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1044,1224],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1080,1224],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1116,1224],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1152,1224],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1188,1224],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1224,1224],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([432,1368],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([810,1368],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2232,990],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2232,1026],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2232,864],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2232,900],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2232,936],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2232,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,1152],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2232,1188],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2232,1224],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2232,1278],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2232,1314],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([2142,864],0,62051256,180)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.pgb([2142,900],0,62054088,200)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.pgb([2268,864],0,62057000,970)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,900],0,62059776,960)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,936],0,62062552,950)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,990],0,62065496,930)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2268,1188],0,62068432,770)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,1224],0,62071208,740)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,360],0,62073984,1160)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "100"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2268,720],0,62076896,1000)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "100"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-25"
    Max = "25"
    }
   0.datalabel([1224,1368],0,0,-1)
    {
    Name = "Fault"
    }
   0.pgb([2142,1476],0,62080704,370)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([1044,792],0,0,-1)
    {
    Name = "F4"
    }
   0.voltmetergnd([954,774],0,0,160)
    {
    Name = "V3"
    }
   0.datalabel([864,702],0,0,-1)
    {
    Name = "F3"
    }
   -Wire-([1494,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1566,1314],0,0,-1)
    {
    Name = "tap"
    }
   0.datalabel([540,540],6,0,-1)
    {
    Name = "tap"
    }
   -Wire-([540,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([342,558],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([990,756],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([882,666],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1044,774],0,0,-1)
    {
    Name = "FT4"
    }
   0.breaker3([1026,756],0,0,550)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-20.19"
    Q = "-5.069"
    }
   0.datalabel([774,612],0,0,-1)
    {
    Name = "F2"
    }
   -Wire-([918,558],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([2142,396],0,62094536,1150)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.08"
    }
   0.pgb([2268,396],0,62097576,1120)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "100"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2142,756],0,62100488,990)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.08"
    }
   0.pgb([2268,756],0,62103400,980)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "100"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2142,936],0,62106312,220)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   -Sticky-([2124,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 2124,36,2232,72
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   -Wire-([576,1332],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([990,1332],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.var([36,1494],0,62110584,340)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.var([36,1530],0,62113736,360)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([198,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([180,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([2142,1512],0,62117432,380)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "20"
    Max = "30"
    }
   -Wire-([414,558],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([756,576],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1854,1044],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1440,1242],0,0,-1)
    {
    Name = "Breaker"
    }
   -Wire-([1062,756],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.var_pot([1656,1314],0,62123120,310)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1728,1314],0,0,320)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([702,360],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([720,396],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([720,378],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([1602,1242],0,0,-1)
    {
    Vertex="0,0;-162,0"
    }
   0.datalabel([1584,1224],2,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([1836,1188],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1800,1440],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1836,1440],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1620,1224],2,0,-1)
    {
    Name = "B5"
    }
   0.var_pot([1458,1314],0,62133464,290)
    {
    Name = "tap"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = ".9"
    F2 = ".95"
    F3 = "1.0"
    F4 = "1.05"
    F5 = "1.1"
    F6 = "1.15"
    F7 = "1.2"
    F8 = "1.25"
    F9 = "1.3"
    F10 = "1.35"
    }
   0.datalabel([1800,1188],2,0,-1)
    {
    Name = "FT4"
    }
   0.datatap([1476,1224],6,0,540)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1512,1224],6,0,530)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1548,1224],6,0,520)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1584,1224],6,0,510)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1620,1224],6,0,500)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1764,1188],2,0,-1)
    {
    Name = "FT3"
    }
   0.mux_array([1746,1386],6,0,490)
    {
    DPath = "0"
    }
   0.datatap([1692,1188],6,0,870)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1728,1188],6,0,860)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1764,1188],6,0,850)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.mux_array([1746,1242],0,0,760)
    {
    DPath = "0"
    }
   0.datatap([1800,1188],6,0,820)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1836,1188],6,0,810)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1674,1206],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([1692,1440],0,0,660)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1728,1440],0,0,650)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1800,1440],0,0,630)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1836,1440],0,0,620)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1674,1422],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([1764,1440],0,0,640)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1764,1440],0,0,-1)
    {
    Name = "F3"
    }
   0.pgb([2142,162],0,62157064,1280)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2142,198],0,62160072,1260)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2142,234],0,62162848,1230)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   -Wire-([630,342],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   0.pgb([2268,684],0,62166040,1020)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2268,648],0,62169080,1040)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.datalabel([1764,1314],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1764,1314],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.unity([1764,1314],4,0,470)
    {
    IType = "2"
    OType = "1"
    }
   0.var_pot([1836,1314],2,62174192,330)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "10"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.datalabel([1854,1062],0,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([2106,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,990],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2106,1026],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2106,1062],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2106,1098],0,0,-1)
    {
    Name = "I30"
    }
   0.pgb([2142,990],0,62183048,940)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.04"
    Max = "0.04"
    }
   0.pgb([2142,1062],0,62185880,900)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.04"
    Max = "0.04"
    }
   0.pgb([2142,1098],0,62188792,890)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2142,1026],0,62191704,920)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.04"
    Max = "0.04"
    }
   -Wire-([2106,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([2142,1188],0,62195880,790)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([2142,1224],0,62198960,750)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([2142,1260],0,62201872,730)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.08"
    }
   0.pgb([2142,1152],0,62204784,830)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.datalabel([2106,1152],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2106,1188],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2106,1224],0,0,-1)
    {
    Name = "I4C"
    }
   0.ground([612,684],1,0,-1)
    {
    }
   -ControlPanel-([576,774],0)
    {
    Name = "Display"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Meter(62315856)
    }
   0.pgb([2142,288],0,62218968,1210)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.08"
    }
   0.pgb([2142,324],0,62221880,1190)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.08"
    }
   0.pgb([2142,360],0,62224936,1170)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.08"
    }
   0.datalabel([432,594],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([432,612],0,0,-1)
    {
    Name = "F1"
    }
   0.breaker3([378,558],4,0,580)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "19.41"
    Q = "7.387"
    }
   -Wire-([504,558],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.breaker3([882,558],4,0,570)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "19.2"
    Q = "5.423"
    }
   -Wire-([666,558],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([612,684],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([648,594],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.resistive_load([1134,756],0,0,-1)
    {
    P = "20.0 [MW]"
    V = "25 [kV]"
    SD = "0"
    }
   0.reactive_load([1206,756],0,0,-1)
    {
    S = "5.0 [MVAR]"
    V = "25 [kV]"
    F = "$(f)"
    SD = "0"
    }
   0.pgb([2268,1314],0,62239048,700)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "10"
    }
   0.pgb([2268,1278],0,62242072,720)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2268,1026],0,62244984,910)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   -Wire-([2106,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1260],0,0,-1)
    {
    Name = "I40"
    }
   -Wire-([2106,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1314],0,0,-1)
    {
    Name = "I5A"
    }
   0.datalabel([2106,1350],0,0,-1)
    {
    Name = "I5B"
    }
   0.datalabel([2106,1386],0,0,-1)
    {
    Name = "I5C"
    }
   0.datalabel([2106,1422],0,0,-1)
    {
    Name = "I50"
    }
   0.pgb([2142,1314],0,62254144,710)
    {
    Name = "I5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0e-005"
    Max = "4.0e-005"
    }
   0.pgb([2142,1422],0,62256920,600)
    {
    Name = "I50"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0e-005"
    Max = "4.0e-005"
    }
   -Wire-([2232,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,1368],0,0,-1)
    {
    Name = "P5"
    }
   0.datalabel([2232,1404],0,0,-1)
    {
    Name = "Q5"
    }
   0.pgb([2268,1368],0,62262328,680)
    {
    Name = "P5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2268,1404],0,62265296,610)
    {
    Name = "Q5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "10"
    }
   0.pgb([2142,1350],0,62268208,690)
    {
    Name = "I5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0e-005"
    Max = "4.0e-005"
    }
   0.pgb([2142,1386],0,62271120,670)
    {
    Name = "I5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0e-005"
    Max = "4.0e-005"
    }
   -Bus-([954,540],0,50579288,-1)
    {
    P1 = [0,0]
    P2 = [0,234]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([1026,558],0,0,560)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.12"
    Q = "-0.3538"
    }
   -Wire-([1062,558],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var([1206,630],5,62278592,110)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "40"
    Min = "0.0"
    Value = "25.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1152,630],5,62281576,100)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   -Sticky-([162,432],0)
    {
    Name = ""
    Font = 1
    Bounds = 162,432,252,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.var([252,630],3,62284944,70)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([198,630],3,62288656,60)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([234,558],6,0,420)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1170,558],2,0,430)
    {
    Name = "Stn2"
    MVA = "100.0 [MVA]"
    Vm = "25.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([1512,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1584,1386],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([396,576],0,0,1140)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([738,576],0,0,1110)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([900,666],4,0,1090)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1080,756],4,0,1050)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([684,360],0,0,1240)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.annotation([1476,1368],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.resistor([612,666],0,0,-1)
    {
    R = ".10 [ohm]"
    }
   0.xfmr-3p3w([630,558],0,0,1130)
    {
    Name = "T1"
    Tmva = "25 [MVA]"
    f = "$(f)"
    YD1 = "0"
    YD2 = "1"
    YD3 = "0"
    Lead = "1"
    Xl12 = "0.1 [pu]"
    Xl13 = "0.1 [pu]"
    Xl23 = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "3"
    View = "1"
    Dtls = "1"
    V1 = "230.0 [kV]"
    V2 = "10 [kV]"
    V3 = "25 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    ILA3 = ""
    ILB3 = ""
    ILC3 = ""
    IAB3 = ""
    IBC3 = ""
    ICA3 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   .Plots_B2([882,432],0,0,20)
    {
    }
   .Plots_1([1026,432],0,0,30)
    {
    }
   .Plots_B1([378,432],0,0,10)
    {
    }
   0.breaker3([666,342],4,0,590)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B5"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I5A"
    IBRB = "I5B"
    IBRC = "I5C"
    IBR0 = "I50"
    SBRA = "Br5A"
    SBRB = "Br5B"
    SBRC = "Br5C"
    BP = "P5"
    BQ = "Q5"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0.0003801"
    Q = "3.854e-015"
    }
   0.pgb([1566,1314],0,62315856,300)
    {
    Name = "off line tap "
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.9"
    Max = "1.35"
    }
   0.var([1476,1386],0,62318688,350)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([1116,1296],0,0,780)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V3a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V3b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V3c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I3a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I3b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I3c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([702,1296],0,0,840)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([324,1296],0,0,880)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([108,1260],1,0,240)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([486,1260],1,0,260)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([882,1260],1,0,280)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([918,1296],6,0,460)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([198,1332],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.select([144,1296],6,0,440)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([108,1332],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   0.select([522,1296],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([486,1332],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([882,1332],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([72,1494],0,0,-1)
    {
    Vertex="0,0;810,0"
    }
   -Wire-([72,1530],0,0,-1)
    {
    Vertex="0,0;918,0"
    }
   -Wire-([954,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([918,1224],1,62363240,270)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([522,1224],1,62365960,250)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([144,1224],1,62368680,230)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1854,1098],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1908,1098],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1854,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1908,1044],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,432,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case Description: 
- Two Thevinen Impedance sources connected via a Y-D-Y transformer.
- Faults can be applied to the 10 kV Delta tertiary winding 
- System voltage is 230kV/25kV settable via source equivalents.
- Simulates two systems with a feeder load.
- Five fault positions for full fault control ahead and behind station relays.
- Five breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   .Controls([1944,1080],4,0,480)
    {
    }
   -Sticky-([648,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,36,1044,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Wire-([414,558],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.multimeter([486,558],0,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([828,558],4,0,50)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([2106,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1476],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2106,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1512],0,0,-1)
    {
    Name = "V2rms"
    }
   -Divider-([36,1134],0)
    {
    Size(1980,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([2016,1530],0)
    {
    Size(0,-1494)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 }

